<?php

namespace ViartasCore\Core\Traits;

use Spatie\Image\Enums\Fit;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use ViartasCore\Core\Drivers\RouteDriver;

Trait HasImages
{
    use InteractsWithMedia;

    /**
     * @var bool
     */
    protected bool $usesMedia = true;

    /**
     * @return bool
     */
    public function usesMedia(): bool
    {
        return $this->usesMedia;
    }

    /**
     * @param Media|null $media
     * @return void
     */
    public function registerMediaConversions(?\Spatie\MediaLibrary\MediaCollections\Models\Media $media = null): void
    {
        //make theme to register thumbs by modules
        $this
            ->addMediaConversion('preview')
            ->fit(Fit::Contain, 300, 300)
            ->nonQueued();
    }

    /**
     * @param mixed $pathToFile
     * @param string $collectionName
     * @param string $disk
     * @return Media
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     */
    public function uploadMedia(mixed $pathToFile, string $collectionName = 'images', string $disk = 'public'): Media
    {
        return $this->addMedia($pathToFile)
            ->toMediaCollection($collectionName, $disk);
    }

    /**
     * @return RouteDriver
     */
    public function routeUploadImages(): RouteDriver
    {
        $route = 'accounting.images.upload';

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return void
     */
    protected static function bootHasMetaTags(): void
    {
        self::addPackageMenuItem('meta', 'Meta data', 'routeMeta');
    }
}
