<?php

namespace ViartasCore\Core\Tables;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasBuilders\Tables\DataTablesRow;
use Illuminate\Http\Request;
use ViartasCore\Core\Models\AccountingUser;

class UsersTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new AccountingUser(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            (new DataTablesRow())->field('email')
                ->setSearchable()
                ->title(__('Email')),
            (new DataTablesRow())->field('name')
                ->setSearchable()
                ->title(__('Username')),
            $this->fieldCreatedAt(),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.users.index'));
        $this->setFilters(route('accounting.users.index'));
        $this->setId('users-table');
        $this->setClass('users-table');
        $this->setTitle(__('Accounting users'));
        $this->setIndexColumn('id');

        return $this;
    }
}
