<?php

namespace ViartasCore\Core\Tables;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use ViartasBuilders\Tables\DataTablesRow;
use Illuminate\Http\Request;
use ViartasCore\Core\Models\Menu;

class MenusTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new Menu(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldGuard(),
            $this->fieldTitle(),
            $this->fieldUser(),
            $this->fieldCreatedAt(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
            ->field('is_visible')
            ->title(__('Visibility')),
            $this->fieldTag(),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())
                    ->setTitle(__('Menu list'))
                    ->setIcon('fa-list')
                    ->setRoute(function (Menu $model) {
                        return $model->routeMenusList();
                    })
                )
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.menus.index'));
        $this->setFilters(route('accounting.menus.index'));
        $this->setId('menus-table');
        $this->setClass('menus-table');
        $this->setTitle(__('Menus'));
        $this->setIndexColumn('id');

        return $this;
    }

    public function fieldGuard(): DataTablesRow
    {
        return (new DataTablesRow())
            ->field('guard')
            ->title(__('Guard'))
            ->setSelectable();
    }

    public function fieldTag(): DataTablesRow
    {
        return (new DataTablesRow())
            ->field('tag')
            ->title(__('Tag'))
            ->render(function ($model) {
                $tags = sprintf(
                    '<span class="badge badge-light-primary badge-xs mr-1">{{ menu(%s) }}</span>',
                    $model->id
                );

                if ($model->tag) {
                    $tags .= sprintf(
                        '<span class="badge badge-primary badge-xs mt-1">{{ menu(\'%s\') }}</span>',
                        $model->tag
                    );
                }

                return $tags;
            })
            ->setSearchable();
    }
}
