<?php

namespace ViartasCore\Core\Providers;

use ViartasCore\Core\Commands\Content\GenerateDefault;
use ViartasCore\Core\Commands\Items\ItemCacheRegenerate;
use ViartasCore\Core\Commands\Users\UserCreateNew;

class PackageServiceProvider extends BasePackageServiceProvider
{
    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @return string[]
     */
    public function artisanCommands(): array
    {
        return [
            UserCreateNew::class,
            ItemCacheRegenerate::class,
            GenerateDefault::class,
        ];
    }

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {
        $schedule->command('example:command')->everyMinute();
    }

    /**
     * @return array
     */
    public function configs(): array
    {
        return [
            'activitylog' => 'activitylog',
            'database' => 'database',
            'filesystems' => 'filesystems',
            'logging' => 'logging',
            'mail' => 'mail',
            'media-library' => 'media-library',
            'pulse' => 'pulse',
            'services' => 'services',
            'horizon' => 'horizon',
        ];
    }

    public function providers(): array
    {
        return [
            'AppServiceProvider'
        ];
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [
            'accounting.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/jquery-ui',
                    'file' => 'resources/js/jquery-ui.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/select2',
                    'file' => 'resources/js/select2.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/daterangepicker',
                    'file' => 'resources/js/daterangepicker.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-core/core',
                    'file' => 'resources/js/accounting.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
            ],

            'accounting.menus.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.menus.list' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/nestable',
                    'file' => 'resources/js/nestable.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-core/core',
                    'file' => 'resources/js/menu.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
            ],

            'accounting.modules.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.modules-actions.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.roles.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.users.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'accounting.*' => [
                [
                    'vendor' => 'viartas-js/jquery-ui',
                    'file' => 'resources/css/jquery-ui.css',
                    'type' => 'library', //library, module, script
                ],
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'module', //library, module, script
                ],
                [
                    'vendor' => 'viartas-js/select2',
                    'file' => 'resources/css/select2.css',
                    'type' => 'module', //library, module, script
                ],
                [
                    'vendor' => 'viartas-js/daterangepicker',
                    'file' => 'resources/css/daterangepicker.css',
                    'type' => 'module', //library, module, script
                ],
                [
                    'vendor' => 'viartas-themes/metronic',
                    'file' => 'resources/css/app.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.menus.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.menus.list' => [
                [
                    'vendor' => 'viartas-js/nestable',
                    'file' => 'resources/css/nestable.css',
                    'type' => 'module', //library, module, script
                ],
                [
                    'vendor' => 'viartas-core/core',
                    'file' => 'resources/css/menu.css',
                    'type' => 'module', //library, module, script
                ],
            ],

            'accounting.modules.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.modules-actions.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.roles.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.users.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
        ];
    }
}
