<?php

namespace ViartasCore\Core\Providers;

use Laravel\Horizon\HorizonServiceProvider;

class HorizonCommandsServiceProvider extends HorizonServiceProvider
{
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Laravel\Horizon\Console\ContinueCommand::class,
                \Laravel\Horizon\Console\ContinueSupervisorCommand::class,
                \Laravel\Horizon\Console\ForgetFailedCommand::class,
                \Laravel\Horizon\Console\HorizonCommand::class,
                \Laravel\Horizon\Console\InstallCommand::class,
                \Laravel\Horizon\Console\ListCommand::class,
                \Laravel\Horizon\Console\PauseCommand::class,
                \Laravel\Horizon\Console\PauseSupervisorCommand::class,
                \Laravel\Horizon\Console\PublishCommand::class,
                \Laravel\Horizon\Console\PurgeCommand::class,
                \Laravel\Horizon\Console\StatusCommand::class,
                \Laravel\Horizon\Console\SupervisorCommand::class,
                \Laravel\Horizon\Console\SupervisorsCommand::class,
                \Laravel\Horizon\Console\TerminateCommand::class,
                \Laravel\Horizon\Console\TimeoutCommand::class,
                \Laravel\Horizon\Console\WorkCommand::class,
            ]);
        }

        $this->commands([
            \Laravel\Horizon\Console\SnapshotCommand::class,
            \Laravel\Horizon\Console\ClearCommand::class,
        ]);
    }
}
