<?php

namespace ViartasCore\Core\Providers;

use Illuminate\Support\Facades\View;
use ViartasCore\Core\Facades\Viartas;
use function PHPUnit\Framework\directoryExists;

class BaseThemeServiceProvider extends BasePackageServiceProvider
{
    /**
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @var string
     */
    public string $application = 'web';

    /**
     * @return void
     */
    public function boot(): void
    {
        $this->definePackageVars();

        $this->bootInConsole();
        $this->bootOutOfConsole();
    }

    /**
     * @return void
     */
    private function bootInConsole(): void
    {
        if (! $this->app->runningInConsole()) {
            return;
        }

        $this->addCommands(
            $this->artisanCommands()
        );

        $this->addMigrations(
            $this->package_directory
        );

        $this->addAssets(
            $this->package_directory
        );
    }

    /**
     * @return void
     */
    private function bootOutOfConsole(): void
    {
        if ($this->app->runningInConsole()) {
            return;
        }

        if (Viartas::driver()->app()->current()->tag === $this->application) {

            $theme = Viartas::driver()->theme()->current();

            if ($theme->tag === $this->package) {

                $this->registerControllers();

                $this->registerViews();

                $this->addViews(
                    $this->package_directory
                );

                $this->addPackageJs(
                    $this->javascript()
                );

                $this->addPackageCss(
                    $this->css()
                );

                $this->disableNodePackages(
                    $this->disabledNodePackages()
                );

                $this->addComponents(
                    $this->package_directory
                );
            }
        }
    }

    /**
     * @param array|null $commands
     * @return void
     */
    private function addCommands(?array $commands): void
    {
        $this->commands($commands ?? $this->commands);
    }

    /**
     * @return void
     */
    public function definePackageVars(): void
    {
        $parts = explode("/", $this->package_directory);
        $this->package = $parts[count($parts) - 3];
        $this->vendor = $parts[count($parts) - 4];
    }

    /**
     * @param array $scripts
     * @return void
     */
    public function addPackageJs(array $scripts): void
    {
        if (! $this->app->runningInConsole()) {
            Viartas::driver()->theme()->packageJs($scripts);
        }
    }

    /**
     * @param $package_directory
     * @return void
     */
    private function addViews($package_directory): void
    {
        if (directoryExists($package_directory . '/../../resources/')) {
            View::addLocation($package_directory . '/../../resources/');
        }
    }

    /**
     * @return void
     */
    private function registerControllers(): void
    {
        Viartas::driver()->theme()->controllers(
            $this->controllers()
        );
    }

    /**
     * @return void
     */
    private function registerViews(): void
    {
        Viartas::driver()->theme()->views(
            $this->views()
        );
    }

    /**
     * @return array
     */
    public function controllers(): array
    {
        return [

        ];
    }

    /**
     * @return array
     */
    public function views(): array
    {
        return [

        ];
    }
}
