<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Theme extends Model
{
    use HasFactory;

    public $fillable = [
        'user_id', 'application_id',
        'tag', 'title', 'description',
        'is_default', 'is_active',
    ];

    /**
     * @return HasMany
     */
    public function configs(): HasMany
    {
        return $this->hasMany(ThemeConfig::class);
    }

    /**
     * @return mixed
     */
    public function scopeDefault(): mixed
    {
        return $this->where('is_default', true);
    }
}
