<?php

namespace ViartasCore\Core\Models;

use ViartasCore\Core\Drivers\RouteDriver;

class Role extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'name',
        'guard_name',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected string $module = 'roles';

    /**
     * @var string
     */
    protected string $element_title = 'Role';

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        return [
            'edit' => $this->menuItem(__('Main settings'), $this->routeEdit()),
            'permissions' => $this->menuItem(__('Permissions'), $this->routePermissionsEdit()),
            'activity' => $this->menuItem(__('Activity'), $this->routeEdit()),
        ];
    }

    /**
     * @return RouteDriver
     */
    public function routePermissionsEdit (): RouteDriver
    {
        $route = sprintf('accounting.%s.permissions.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routePermissionsUpdate (): RouteDriver
    {
        $route = sprintf('accounting.%s.permissions.update', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return array
     */
    public function buttons(): array
    {
        $buttons = [];

        return array_merge($buttons, parent::buttons());
    }
}
