<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Route;
use ViartasCore\Core\Drivers\RouteDriver;
use ViartasCore\Core\Traits\HasMetaTags;

class ModuleAction extends BaseModel
{
    use HasMetaTags;

    /**
     * @var string[]
     */
    protected $fillable = [
        'module_id', 'name',
        'title', 'content',
        'route_name', 'route_attributes',
        'is_visible',
        'is_active',
        'is_deleted',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected string $module = 'modules';

    /**
     * @var string
     */
    protected string $element_title = 'Action';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'module_id';
    }

    /**
     * @return BelongsTo
     */
    public function module(): BelongsTo
    {
        return $this->belongsTo(Module::class);
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        $actions['edit'] = $this->menuItem(__('Module settings'), $this->module()->first()->routeEdit());
        //$actions['list'] = $this->menuItem(__('Module views'), $this->routelist());

        foreach ($this->module()->first()->actions as $action) {
            $actions[$action->route_name] = $this->menuItem(
                ! $action->title ? $action->name : $action->title,
                $action->routeEdit(),
                $action
            );
        }

        $actions['activity'] = $this->menuItem(__('Activity'), $this->module()->first()->routeEdit());

        unset(self::$packagesMenus['meta']);

        return $actions;
    }

    /**
     * @param Collection $menu
     * @return bool
     */
    public function menuRouteActive(Collection $menu): bool
    {
        if (! $menu->get('model')) {
            return Route::currentRouteName() == $menu->get('route')->getRouteName();
        }

        return $menu->get('model')->id === $this->id;
    }

    /**
     * @return RouteDriver
     */
    public function routeMetaModulesCustom(): RouteDriver
    {
        $route = 'accounting.modules.meta.edit';

        return new RouteDriver($route, [
            'id' => $this->id,
            'class' => base64_encode(get_class($this)),
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routeEdit (): RouteDriver
    {
        $route = sprintf('accounting.%s.actions.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->module_id,
            'action' => $this->id,
        ]);
    }

    /**
     * @param string $field
     * @return RouteDriver
     */
    public function routeFieldChange (string $field): RouteDriver
    {
        $route = sprintf('accounting.%s.actions.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->module_id,
            'action' => $this->id,
            'field' => $field,
        ], 'PATCH');
    }
}
