<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Route;
use ViartasCore\Core\Drivers\RouteDriver;

class Module extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'guard', 'name',
        'title', 'content',
        'is_visible',
        'is_active',
        'is_deleted',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected string $module = 'modules';

    /**
     * @var string
     */
    protected string $element_title = 'Module';

    /**
     * @var ModuleAction
     */
    private ModuleAction $currentAction;

    /**
     * @return HasMany
     */
    public function actions(): HasMany
    {
        return $this->hasMany(ModuleAction::class);
    }

    /**
     * @return array
     */
    protected function buttonsConfig(): array
    {
        $buttons = [
            'list' => collect([
                'title' => __('List'),
                'route' => $this->routeIndex(),
                'icon' => 'fa-list',
                'size' => 'sm',
                'color' => 'primary',
                'class' => '',
                'type' => [
                    'forms', 'summaries',
                ],
            ]),
        ];

        if (!$this->id) {
            unset($buttons['delete']);
        }

        return $buttons;
    }

    /**
     * @param Collection $menu
     * @return bool
     */
    public function menuRouteActive(Collection $menu): bool
    {
        if (! $menu->get('model')) {
            return Route::currentRouteName() == $menu->get('route')->getRouteName();
        } else {
            return
                Route::currentRouteName() == $menu->get('route')->getRouteName()
                && $menu->get('model')->id === $this->currentAction()->id;
        }
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        //var_dump(3210000);exit;
        $actions = [];
        $actions['edit'] = $this->menuItem(__('Module settings'), $this->routeEdit());
        //$actions['list'] = $this->menuItem(__('Module views'), $this->routelist());

        foreach ($this->actions as $action) {
            $actions[$action->route_name] = $this->menuItem(
                ! $action->title ? $action->name : $action->title,
                $action->routeEdit(),
                $action
            );
        }

        $actions['activity'] = $this->menuItem(__('Activity'), $this->routeEdit());

        return $actions;
    }

    /**
     * @param ModuleAction|false $moduleAction
     * @return ModuleAction
     */
    public function currentAction(ModuleAction|false $moduleAction = false): ModuleAction
    {
        if ($moduleAction) {
            $this->currentAction = $moduleAction;
        }

        return $this->currentAction;
    }

    /**
     * @return RouteDriver
     */
    public function routeActions (): RouteDriver
    {
        $route = sprintf('accounting.%s.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routeList (): RouteDriver
    {
        $route = sprintf('accounting.%s.list', $this->module);

        return new RouteDriver($route, [
            'id' => $this->id,
        ]);
    }
}
