<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use ViartasCore\Core\Drivers\RouteDriver;

class Menu extends BaseModel
{
    use HasFactory;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'tag',
        'guard', 'layout',
        'user_id', 'depth',
        'class', 'attributes',
        'is_visible',
    ];

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var bool
     */
    protected bool $usesMedia = false;

    /**
     * @var string
     */
    protected string $module = 'menus';

    /**
     * @var string
     */
    protected string $element_title = 'Menu';

    /**
     * @return HasMany
     */
    public function items(): HasMany
    {
        return $this->hasMany(MenuItem::class)
            ->whereNull('menu_item_id')
            ->orderBy('sort');
    }

    /**
     * @return RouteDriver
     */
    public function routeMenusList (): RouteDriver
    {
        $RouteDriver = sprintf('accounting.%s.list', $this->module);

        return new RouteDriver($RouteDriver, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        $actions = [];
        $actions['edit'] = $this->menuItem(__('Module settings'), $this->routeEdit());
        $actions['list'] = $this->menuItem(__('Menu list'), $this->routeMenusList());
        $actions['history'] = $this->menuItem(__('Menu history'), $this->routeMenusHistory());
        $actions['activity'] = $this->menuItem(__('Activity'), $this->routeEdit());

        return $actions;
    }

    /**
     * @return RouteDriver
     */
    public function routeMenusHistory (): RouteDriver
    {
        $RouteDriver = sprintf('accounting.%s.history', $this->module);

        return new RouteDriver($RouteDriver, [
            'id' => $this->id,
        ]);
    }

    /**
     * @return array
     */
    public function buttonsConfig(): array
    {
        $buttons = [];

        return array_merge($buttons, parent::buttonsConfig());
    }
}
