<?php

namespace ViartasCore\Core\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Locale extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'tag',
        'is_default', 'is_active',
        'segment_id',
    ];

    /**
     * @return BelongsTo
     */
    public function segment(): BelongsTo
    {
        return $this->belongsTo(Segment::class);
    }

    /**
     * @param $locale
     * @return Builder
     */
    public function scopeLocale($locale): Builder
    {
        return $this->where('tag', $locale);
    }

    /**
     * @return Builder
     */
    public function scopeAvailable(): Builder
    {
        return $this->where('is_active', 1);
    }

    /**
     * @return Locale
     */
    public function scopeDefault(): Locale
    {
        return $this->available()
            ->where('is_default', 1)
            ->first();
    }

    /**
     * @return string
     */
    public function path(): string
    {
        return $this->is_default ? '' : $this->tag;
    }
}
