<?php

use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Blade;
use Illuminate\View\Factory;
use Illuminate\View\View;
use ViartasCore\Core\Drivers\ThemeDriver;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Models\Menu;

if (!function_exists('theme')) {
    /**
     * @return ThemeDriver|null
     */
    function theme(): ?ThemeDriver
    {
        return ! app()->runningInConsole() ? Viartas::driver()->theme() : null;
    }
}

if (!function_exists('theme_view')) {
    /**
     * @param $view
     * @param array $data
     * @param array $mergeData
     * @return Factory|View
     */
    function theme_view($view = null, array $data = [], array $mergeData = []): Factory|View
    {
        return Viartas::driver()->theme()->view($view, $data, $mergeData);
    }
}

if (!function_exists('theme_redirect')) {
    /**
     * @param string|null $to
     * @param int $status
     * @param array $headers
     * @param bool|null $secure
     * @return Redirector|RedirectResponse
     */
    function theme_redirect(string $to = null, int $status = 302, array $headers = [], bool|null $secure = null): Redirector|RedirectResponse
    {
        if (is_null($to)) {
            return Viartas::driver()->redirect();
        }

        return Viartas::driver()->redirect()->to($to, $status, $headers, $secure);
    }
}

if (!function_exists('menu')) {

    /**
     * @param int|string $menu_id
     * @return string
     */
    function menu(int|string $menu_id): string
    {
        $menu = Menu::where('id', $menu_id)->orWhere('tag', $menu_id)->first();

        if (!$menu) {
            return '';
        }

        $menu = (new ViartasBuilders\Menus\Menu(
            $menu
        ));

        //var_dump($menu->list());
        //exit();

        $theme = Viartas::driver()->theme()->current()->tag;

        /**
         * TODO:
         * check if file exists in theme, if not show default menu
        */

        return Cache::remember('menu_'.app()->getLocale().'_'.$menu_id, '1200', function () use ($menu, $theme) {
            $render = sprintf(
                '<x:%s::menus.%s.render :menu="$menu" />',
                $theme,
                $menu->layout()
            );

            return Blade::render($render, [
                'menu' => $menu
            ]);
        });
    }
}

if (!function_exists('vite_css_library')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @return string
     */
    function vite_css_library(string|array $file, ?string $vendor_path = null): string
    {
        if (is_array($file)) {
            foreach ($file as $css) {
                Viartas::driver()->theme()->viteCssLibrary($css[0], $css[1]);
            }

            return '';
        }

        return Viartas::driver()->theme()->viteCssLibrary($file, $vendor_path);
    }
}

if (!function_exists('vite_css_module')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @return string
     */
    function vite_css_module(string|array $file, ?string $vendor_path = null): string
    {
        if (is_array($file)) {
            foreach ($file as $css) {
                Viartas::driver()->theme()->viteCssModule($css[0], $css[1]);
            }

            return '';
        }

        return Viartas::driver()->theme()->viteCssModule($file, $vendor_path);
    }
}

if (!function_exists('vite_css_script')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @return string
     */
    function vite_css_script(string|array $file, ?string $vendor_path = null): string
    {
        if (is_array($file)) {
            foreach ($file as $css) {
                Viartas::driver()->theme()->viteCssScript($css[0], $css[1]);
            }

            return '';
        }

        return Viartas::driver()->theme()->viteCssScript($file, $vendor_path);
    }
}

if (!function_exists('vite_js_library')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @param string $type
     * @return string
     */
    function vite_js_library(string|array $file, ?string $vendor_path = null, string $type = 'module'): string
    {
        if (is_array($file)) {
            foreach ($file as $js) {
                Viartas::driver()->theme()->viteJsLibrary($js[0], $js[1],$js[2] ?? 'module');
            }

            return '';
        }

        return Viartas::driver()->theme()->viteJsLibrary($file, $vendor_path, $type);
    }
}

if (!function_exists('vite_js_module')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @param string $type
     * @return string
     */
    function vite_js_module(string|array $file, ?string $vendor_path = null, string $type = 'module'): string
    {
        if (is_array($file)) {
            foreach ($file as $js) {
                Viartas::driver()->theme()->viteJsModule($js[0], $js[1],$js[2] ?? 'module');
            }

            return '';
        }

        return Viartas::driver()->theme()->viteJsModule($file, $vendor_path, $type);
    }
}

if (!function_exists('vite_js_script')) {

    /**
     * @param string|array $file
     * @param string|null $vendor_path
     * @param string $type
     * @return string
     */
    function vite_js_script(string|array $file, ?string $vendor_path = null, string $type = 'module'): string
    {
        if (is_array($file)) {
            foreach ($file as $js) {
                Viartas::driver()->theme()->viteJsScript($js[0], $js[1],$js[2] ?? 'module');
            }

            return '';
        }

        return Viartas::driver()->theme()->viteJsScript($file, $vendor_path, $type);
    }
}
