<?php

namespace ViartasCore\Core\Forms\Roles;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasCore\Core\Models\Role;

class RoleEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.roles.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.roles.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'name' => [
                    'title' => __('Role title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => true,
                    'rules' => ['required', 'string', 'max:255', 'unique:roles,name,id'],
                    'model' => Role::class,
                    'primary_key' => 'id',
                    'primary_value' => request()->id ?? false,
                ],
                'guard_name' => [
                    'title' => __('Guard name'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'options' => [
                        'web' => 'web',
                        'accounting' => 'accounting',
                        'api' => 'api',
                    ],
                    'required' => true,
                    'rules' => ['required', 'string', 'max:255'],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Role settings'),
                'layout' => Group::CARD,
                'size' => 12,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
