<?php

namespace ViartasCore\Core\Forms\Meta;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasModules\Pages\Models\Accounting\Page;

class MetaEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.meta.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.meta.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                        'class' => 'class',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => false,
                ],
                'menu_title' => [
                    'title' => __('Menu title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => false,
                ],
                'keywords' => [
                    'title' => __('Keywords'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => false,
                ],
                'description' => [
                    'title' => __('Description'),
                    'type' => Field::TEXTAREA,
                    'size' => 12,
                    'translatable' => true,
                    'required' => false,
                ],
            ],
            'group2' => [
                'menu_icon' => [
                    'title' => __('Icon'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'required' => false,
                ],
                'menu_target' => [
                    'title' => __('Target'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'required' => false,
                    'options' => ['', '_blank']
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Meta content'),
                'layout' => Group::CARD,
                'size' => 8,
            ],
            'group2' => [
                'title' => __('Meta settings'),
                'layout' => Group::CARD,
                'size' => 4,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
