<?php

namespace ViartasCore\Core\Forms\Common;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasModules\Pages\Models\Accounting\Page;

class ImagesUploadForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form-media',
            'class' => 'form-media',
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'images' => [
                    'title' => __('Upload images'),
                    'type' => Field::MEDIA,
                    'size' => 12,
                    'model' => Page::class,
                    'primary_key' => 'id',
                ],
            ]
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Upload images'),
                'layout' => Group::CARD,
                'size' => 12,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
