<?php

namespace ViartasCore\Core\Drivers;

use DateInterval;
use DateTimeInterface;
use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Redirector;
use ViartasCore\Core\Facades\Viartas;

class RedirectDriver extends Redirector
{
    /**
     * @param string $path
     * @param int $status
     * @param array $headers
     * @param bool|null $secure
     * @return RedirectResponse
     */
    public function to($path, $status = 302, $headers = [], $secure = null): RedirectResponse
    {
        return app('redirect')->createRedirect($this->generator->to($path, [], $secure), $status, $headers);
    }

    /**
     * @param string $route
     * @param array $parameters
     * @param int $status
     * @param array $headers
     * @return RedirectResponse
     */
    public function route($route, $parameters = [], $status = 302, $headers = []): RedirectResponse
    {
        return $this->to($this->generator->route($this->getRoute($route), $parameters), $status, $headers);
    }

    /**
     * @param  string  $route
     * @param  mixed  $parameters
     * @param  DateTimeInterface|DateInterval|int|null  $expiration
     * @param  int  $status
     * @param  array  $headers
     * @return RedirectResponse
     */
    public function signedRoute($route, $parameters = [], $expiration = null, $status = 302, $headers = [])
    {
        return $this->to($this->generator->signedRoute($this->getRoute($route), $parameters, $expiration), $status, $headers);
    }

    /**
     * @param  string  $route
     * @param  DateTimeInterface|DateInterval|int|null  $expiration
     * @param  mixed  $parameters
     * @param  int  $status
     * @param  array  $headers
     * @return RedirectResponse
     */
    public function temporarySignedRoute($route, $expiration, $parameters = [], $status = 302, $headers = []): RedirectResponse
    {
        return $this->to($this->generator->temporarySignedRoute($this->getRoute($route), $expiration, $parameters), $status, $headers);
    }

    /**
     * @param string $path
     * @return string
     */
    public function getRoute(string $path): string
    {
        return $path;
        //return Viartas::driver()->theme()->views()[$path] ?? $path;
    }
}
