<?php

namespace ViartasCore\Core\Drivers;

use Illuminate\Database\Eloquent\Collection;
use ViartasCore\Core\Models\Locale;

class LocaleDriver
{
    /**
     * @var Locale|null
     */
    private ?Locale $locale;

    /**
     * @param Locale|null $locale
     */
    public function __construct(?Locale $locale)
    {
        $this->locale = $locale;
        return $this;
    }

    /**
     * @return Collection|bool
     */
    public function all(): Collection|bool
    {
        return Locale::get();
    }

    /**
     * @return Collection
     */
    public function active(): Collection
    {
        return Locale::active()->get();
    }

    /**
     * @return Locale|null
     */
    public function default(): ?Locale
    {
        return Locale::default()->first();
    }

    /**
     * @return Locale|null
     */
    public function current(): ?Locale
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function path(): string
    {
        return $this->current()?->path() ?? '';
    }
}
