<?php

namespace ViartasCore\Core\Drivers;

use ViartasCore\Core\Models\Application;
use ViartasCore\Core\Models\Theme;

class InstallDriver
{
    /**
     * @param string $theme_package
     * @param string $application
     * @return Theme
     */
    public function theme(string $theme_package, string $application = 'web'): Theme
    {
        $application = Application::query()
            ->where('tag', $application)
            ->first();

        $theme = $application->themes()
            ->where('tag', $theme_package)
            ->first();

        if (!$theme) {
            $themes = $application->themes()->get();

            $theme = $application->themes()
                ->create([
                    'tag' => $theme_package,
                ]);

            if ($themes->count() === 0) {
                $theme->is_default = true;
                $theme->save();
            }
        }

        return $theme;
    }
}
