<?php

namespace ViartasCore\Core\Controllers;

use App\Http\Controllers\Controller;
use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Validation\ValidationException;
use Spatie\Permission\Models\Role;
use ViartasBuilders\Tables\Traits\HasTable;
use ViartasCore\Core\Facades\Viartas;
use ViartasShop\Cart\Facades\ViartasCart;

class WebController extends Controller
{
    use HasTable;

    /**
     * @var string
     */
    protected string $guard = 'web';

    /**
     *
     */
    public function __construct()
    {
        if (app()->runningInConsole()) {
            return;
        }

        $this->middleware(['ensureCartCookie', function ($request, Closure $next) {

            return $next($request);
        }]);

        $guard = $this->guard;

        //$has_permission = false;
        $route = request()->route();

        if ($route->methods()[0] != 'GET') {
            $twin = $this->findGetTwinOfCurrent(request());

            if ($twin) {
                $route = $twin;
            }
        }

        $route_for_check = $route->getAction()['as'];

        if (Viartas::driver()->locale()->path() != '') {
            $parts = explode('.', $route_for_check);
            if (isset($parts[1]) && $parts[1] == Viartas::driver()->locale()->path()) {
                array_splice($parts, 1, 1);
            }
            $route_for_check = implode('.', $parts);
        }

        //if (Auth::Guest()) {
            $guestRole = Role::findByName('guest');
            $has_permission = $guestRole->hasPermissionTo($route_for_check, $this->guard);
        //}

        /*if ($user = Auth::user()) {

            if (is_null($user->email_verified_at)) {
                throw ValidationException::withMessages([
                    'email' => __('Please verify your email before logging in.'),
                ]);
            }
        }*/

        if (! $has_permission) {

            $this->middleware(['auth', function ($request, $next) use ($guard, $route, $route_for_check) {

                $user = (Auth::user() ?? abort(403));

                if (is_null($user->email_verified_at)) {

                }

                if ($user->hasRole('admin')) {
                    return $next($request);
                }

                if ($user->hasPermissionTo($route_for_check, $guard)) {
                    return $next($request);
                }

                abort(403);
            }]);
        }

        $this->middleware(['theme', function ($request, Closure $next) {

            $route = $request->route();
            $routeControllerParts = explode('@', $route->getAction()['controller']);

            $routeController = $routeControllerParts[0];
            $routeMethod = $routeControllerParts[1];

            $themeControllers = Viartas::driver()->theme()->controllers();

            if (isset($themeControllers[$routeController])) {

                $themeController = $themeControllers[$routeController] . '@' . $routeMethod;

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $themeController,
                    'controller' => $themeController,
                ]);

                $route->setAction($routeAction);
                $route->controller = false;
            }

            return $next($request);
        }]);
    }

    function findGetTwinOfCurrent($request): ?\Illuminate\Routing\Route
    {
        $current = $request->route();                 // current Route (maybe POST)
        if (!$current) return null;

        // Only try if the current route actually handles POST
        if (!in_array('POST', $current->methods(), true)) return null;

        $routes = Route::getRoutes();

        foreach ($routes as $r) {
            // same domain (including subdomain patterns), same URI pattern
            $sameUri    = $r->uri() === $current->uri();
            $sameDomain = $r->domain() === $current->domain();

            if ($sameUri && $sameDomain && in_array('GET', $r->methods(), true)) {
                return $r; // found the GET twin
            }
        }

        return null; // none found
    }
}
