<?php

namespace ViartasCore\Core\Controllers;

use App\Http\Controllers\Controller;
use Closure;
use ViartasBuilders\Tables\Traits\HasTable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use ViartasCore\Core\Facades\Viartas;

class WebAuthController extends WebController
{
    use HasTable;

    /**
     *
     */
    public function __construct()
    {
        $guard = $this->guard;

        $this->middleware(['auth', function ($request, $next) use ($guard) {
            $user = (Auth::user() ?? abort(403));
            if ($user->hasRole('admin')) {
                return $next($request);
            }

            if ($user->hasPermissionTo(Route::currentRouteName(), $guard)) {
                return $next($request);
            }

            abort(403);
        }]);

        parent::__construct();
    }
}
