<?php

namespace ViartasCore\Core\Controllers;

use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use ViartasCore\Core\Forms\Users\UserEditForm;
use ViartasCore\Core\Forms\Users\UserRolesForm;
use ViartasCore\Core\Tables\UsersTable;
use ViartasModules\Pages\Models\Accounting\Page;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Spatie\Permission\Models\Role;
use ViartasCore\Core\Models\AccountingUser;
use ViartasCore\Core\Models\User;

class UsersController extends AccountingController
{
    /**
     * @param UsersTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(UsersTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
       /* $routes = Route::getRoutes();
        foreach ($routes as $route) {
            var_dump($route->getName());
        }
        exit;*/
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.users.index', compact('table'))
        );
    }

    /**
     * @param UserEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function create(UserEditForm $form): View|Factory|Application|\Illuminate\Foundation\Application
    {
        return theme_view('accounting.users.edit', [
            'form' => $form->build(),
            'element' => new AccountingUser(),
        ]);
    }

    /**
     * @param UserEditForm $form
     * @return RedirectResponse
     */
    public function store(UserEditForm $form): RedirectResponse
    {
        $user = AccountingUser::create($form->all());

        return theme_redirect()->route('accounting.users.edit', [
            'id' => $user->id,
        ])->with('success', __('user.created'));
    }

    /**
     * @param string $id
     * @param UserEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, UserEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $user = AccountingUser::findOrFail($id);
        $form = $form->setAction('update')->build($user);

        return theme_view('accounting.users.edit', [
            'form' => $form,
            'element' => $user,
        ]);
    }

    /**
     * @param string $id
     * @param UserEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, UserEditForm $form): RedirectResponse
    {
        AccountingUser::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.users.edit', [
            'id' => $id,
        ])->with('success', __('user.updated'));
    }

    /**
     * @param string $id
     * @param UserRolesForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function rolesEdit(string $id, UserRolesForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $user = User::query()->with('roles')->findOrFail($id);

        $roles = [];
        foreach ($user->roles as $role) {
            $roles['roles.'.$role['guard_name']][] = $role['id'];
        }

        $model = new AccountingUser();
        $model->roles = $roles;
        $model->id = $id;

        $form = $form->setAction('update')->build($model);

        return theme_view('accounting.users.roles.edit', [
            'form' => $form,
            'element' => AccountingUser::findOrFail($id),
        ]);
    }

    /**
     * @param string $id
     * @param UserRolesForm $form
     * @return RedirectResponse
     */
    public function rolesUpdate(string $id, UserRolesForm $form): RedirectResponse
    {
        $user = User::query()->findOrFail($id);
        $user->syncRoles([]);

        foreach ($form->roles as $guard => $roles) {
            foreach ($roles as $role) {
                $user->assignRole(
                    Role::findOrFail($role)
                );
            }
        }

        return theme_redirect()->route('accounting.users.roles.edit', [
            'id' => $id,
        ])->with('success', __('user.roles.updated'));
    }

    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        User::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            User::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.users.index')
                ->with('success', __('user.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            User::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }

    /**
     * @param $id
     * @param ImagesUploadForm $images
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function uploadImages($id, ImagesUploadForm $images): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $page = Page::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(Page::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.pages.common', [
            'form' => $images,
            'element' => $page,
        ]);
    }

}
