<?php

namespace ViartasCore\Core\Controllers\RouteGuessers;

use App\Http\Controllers\Controller;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Spatie\Permission\Models\Role;
use ViartasCore\Core\Facades\Viartas;
use ViartasShop\Cart\Facades\ViartasCart;

class WebRouteGuesserController extends Controller
{
    protected string $guard = 'web';

    public function __construct()
    {
        if (app()->runningInConsole()) {
            return;
        }

        $this->guess();
    }

    public function guessRoute(Request $request): void
    {
        //parent::__construct();
    }

    /**
     * @return void
     */
    private function guess(): void
    {
        $this->middleware(['ensureCartCookie', function ($request, Closure $next) {
            return $next($request);
        }]);

        $request = request();
        $packageGuessers = Viartas::driver()->app()->getPackagesRouteGuessers();

        $error = false;
        $found = false;

        foreach ($packageGuessers as $packageGuesser) {

            if ($found) {
                break;
            }

            $route = $packageGuesser->guessRoute($request);

            if (is_int($route)) {
                $error = $route;
            } else {

                $found = true;
                $model = $route;
                $moduleController = $model->controller();

                $route = $request->route();
                $id = $request->route('element') ?? $model->id;

                $route->setParameter('element', $id);

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $moduleController,
                    'controller' => $moduleController,
                    'as' => 'web.'.$model->getModule().'.index',
                    'original_route' => $route->getAction()['as'],
                ]);
            }
        }

        if(! $found ) {
            abort($error);
        }

        $guard = $this->guard;
        $has_permission = false;

        $route_for_check = $routeAction['as'];

        if (Viartas::driver()->locale()->path() != '') {
            $parts = explode('.', $route_for_check);
            if (isset($parts[1]) && $parts[1] == Viartas::driver()->locale()->path()) {
                array_splice($parts, 1, 1);
            }
            $route_for_check = implode('.', $parts);
        }

        //if (Auth::Guest()) {
            $guestRole = Role::findByName('guest');
            $has_permission =
                $guestRole->hasPermissionTo($route_for_check, $this->guard) && $guestRole->hasPermissionTo($routeAction['original_route'], $this->guard);
        //}

        if (! $has_permission) {
            $this->middleware(['auth', function ($request, $next) use ($guard, $route, $routeAction, $route_for_check) {
                $user = (Auth::user() ?? abort(403));

                if ($user->hasRole('admin')) {
                    return $next($request);
                }

                if ($user->hasPermissionTo($route_for_check, $guard) && $user->hasPermissionTo($routeAction['original_route'], $guard)) {
                    return $next($request);
                }

                abort(403);
            }]);
        }

        $this->middleware(['routeGuesser', function ($request, Closure $next) use ($routeAction) {
            $route = $request->route();
            $route->setAction($routeAction);
            $route->controller = false;
            return $next($request);
        }]);
    }
}
