<?php

namespace ViartasCore\Core\Controllers\RouteGuessers;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use ViartasCore\Core\Controllers\AccountingController;
use ViartasCore\Core\Facades\Viartas;

class AccountingRouteGuesserController extends AccountingController
{
    /**
     * @param Request $request
     * @return \Illuminate\Foundation\Application|View|Factory|Application
     */
    public function guessRoute(Request $request): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $packageGuessers = Viartas::driver()->app()->getPackagesRouteGuessers();

        $error = false;

        foreach ($packageGuessers as $packageGuesser) {
            $route = $packageGuesser->guessRoute($request);

            if (is_int($route)) {
                $error = $route;
            } else {
                return $route;
            }
        }

        abort($error);
    }
}
