<?php

namespace ViartasCore\Core\Controllers;

use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use ViartasCore\Core\Forms\Roles\RoleEditForm;
use ViartasCore\Core\Forms\Roles\RolesPermissionsForm;
use ViartasCore\Core\Forms\Users\UserEditForm;
use ViartasCore\Core\Forms\Users\UserRolesForm;
use ViartasCore\Core\Tables\RolesTable;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use ViartasCore\Core\Models\Role;
use ViartasCore\Core\Models\User;

class RolesController extends AccountingController
{
    /**
     * @param RolesTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(RolesTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
       /* $routes = Route::getRoutes();
        foreach ($routes as $route) {
            var_dump($route->getName());
        }
        exit;*/
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.roles.index', compact('table'))
        );
    }

    /**
     * @param RoleEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function create(RoleEditForm $form): View|Factory|Application|\Illuminate\Foundation\Application
    {
        return theme_view('accounting.roles.edit', [
            'form' => $form->build(),
            'element' => new Role(),
        ]);
    }

    /**
     * @param RoleEditForm $form
     * @return RedirectResponse
     */
    public function store(RoleEditForm $form): RedirectResponse
    {
        $role = Role::create($form->all());

        return theme_redirect()->route('accounting.roles.edit', [
            'id' => $role->id,
        ])->with('success', __('role.created'));
    }

    /**
     * @param string $id
     * @param RoleEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, RoleEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $role = Role::findOrFail($id);
        $form = $form->setAction('update')->build($role);

        return theme_view('accounting.roles.edit', [
            'form' => $form,
            'element' => $role,
        ]);
    }

    /**
     * @param string $id
     * @param RoleEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, RoleEditForm $form): RedirectResponse
    {
        Role::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.roles.edit', [
            'id' => $id,
        ])->with('success', __('role.updated'));
    }

    /**
     * @param string $id
     * @param UserEditForm $form
     * @return RedirectResponse
     */
    public function rolesUpdate(string $id, UserRolesForm $form): RedirectResponse
    {
        $user = User::query()->findOrFail($id);
        $user->syncRoles([]);

        foreach ($form->roles as $guard => $roles) {
            foreach ($roles as $role) {
                $user->assignRole(
                    \Spatie\Permission\Models\Role::findOrFail($role)
                );
            }
        }

        return theme_redirect()->route('accounting.users.roles.edit', [
            'id' => $id,
        ])->with('success', __('user.roles.updated'));
    }

    /**
     * @param string $id
     * @param RolesPermissionsForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function permissionsEdit(string $id, RolesPermissionsForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $role = \Spatie\Permission\Models\Role::findOrFail($id);

        $permissions = [];
        foreach ($role->permissions as $permission) {
            $parts = explode(".", $permission->name);
            $permissions['roles.'.$parts[1]][] = $permission->name;
        }

        $role->roles = $permissions;

        $form = $form->setAction('update')->build($role);

        return theme_view('accounting.roles.permissions.edit', [
            'form' => $form,
            'element' => Role::findOrFail($id),
        ]);
    }

    /**
     * @param string $id
     * @param RolesPermissionsForm $form
     * @return RedirectResponse
     */
    public function permissionsUpdate(string $id, RolesPermissionsForm $form): RedirectResponse
    {
        $permissions = [];
        foreach ($form->roles as $module => $routes) {
            foreach ($routes as $route) {
                $permissions[] = $route;
            }
        }

        $role = \Spatie\Permission\Models\Role::findOrFail($id);
        $role->syncPermissions($permissions);

        return theme_redirect()->route('accounting.roles.permissions.edit', [
            'id' => $id,
        ])->with('success', __('role.permissions.updated'));
    }

    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        Role::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            Role::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.roles.index')
                ->with('success', __('role.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            Role::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }

    /**
     * @param $id
     * @param ImagesUploadForm $images
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function uploadImages($id, ImagesUploadForm $images): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $role = Role::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(Role::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.roles.common', [
            'form' => $images,
            'element' => $role,
        ]);
    }

}
