<?php

namespace ViartasCore\Core\Controllers;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use ViartasCore\Core\Controllers\AccountingController;
use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use ViartasCore\Core\Forms\Meta\MetaEditForm;
use ViartasCore\Core\Models\Meta;
use ViartasModules\Pages\Forms\Accounting\PageEditForm;
use ViartasModules\Pages\Models\Accounting\Page;
use ViartasModules\Pages\Tables\Accounting\PagesTable;

class MetaController extends AccountingController
{
    /**
     * @param string $id
     * @param string $class
     * @param MetaEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, string $class, MetaEditForm $form): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $class = base64_decode($class);
        $element = $class::findOrFail($id);

        if (!$element->meta()->first()) {
            Meta::create([
                'element' => $id,
                'class' => $class,
            ]);

            $element->refresh();
        }

        $form = $form->setAction('update')->build($element->meta()->first());

        return theme_view('accounting.meta.edit', [
            'form' => $form,
            'element' => $element,
        ]);
    }

    /**
     * @param string $id
     * @param string $class
     * @param MetaEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, string $class, MetaEditForm $form): RedirectResponse
    {
        $meta = Meta::findOrFail($id);
        $meta->update($form->all());

        return theme_redirect()->route('accounting.meta.edit', [
            'id' => $meta->element,
            'class' => base64_encode($meta->class),
        ])->with('success', __('meta.updated'));
    }

    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        Page::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }
}
