<?php

namespace ViartasCore\Core\Controllers;

use App\Http\Controllers\Controller;
use Closure;
use ViartasBuilders\Tables\Traits\HasTable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use ViartasCore\Core\Facades\Viartas;

class AccountingController extends Controller
{
    use HasTable;

    /**
     * @var string
     */
    protected string $guard = 'accounting';

    /**
     *
     */
    public function __construct()
    {
        $guard = $this->guard;

        $route_for_check = Route::currentRouteName();

        if (Viartas::driver()->locale()->path() != '') {
            $parts = explode('.', $route_for_check);
            if (isset($parts[1]) && $parts[1] == Viartas::driver()->locale()->path()) {
                array_splice($parts, 1, 1);
            }
            $route_for_check = implode('.', $parts);
        }

        $this->middleware(['auth', function ($request, $next) use ($guard, $route_for_check) {
            $user = (Auth::user() ?? abort(403));
            if ($user->hasRole('admin')) {
                return $next($request);
            }

            if ($user->hasPermissionTo($route_for_check, $guard)) {
                return $next($request);
            }

            abort(403);
        }]);

        $this->middleware(['theme', function ($request, Closure $next) {

            $route = $request->route();
            $routeControllerParts = explode('@', $route->getAction()['controller']);

            $routeController = $routeControllerParts[0];
            $routeMethod = $routeControllerParts[1];

            $themeControllers = Viartas::driver()->theme()->controllers();

            if (isset($themeControllers[$routeController])) {

                $themeController = $themeControllers[$routeController] . '@' . $routeMethod;

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $themeController,
                    'controller' => $themeController,
                ]);

                $route->setAction($routeAction);
                $route->controller = false;
            }

            return $next($request);
        }]);
    }
}
