<?php

namespace ViartasCore\Core\Commands\Items;

use Illuminate\Console\Command;

class ItemCacheRegenerate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'items:cache-regenerate {--model=all} {--item=all}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Regenerates cache for all items';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle(): void
    {
        if ($this->option('model') === 'all') {
            foreach ($this->getModels() as $model) {
                $entity = new $model();

                if ($entity->definesAsItem) {
                    foreach ($entity::all() as $item) {
                        $item->touch();
                    }
                }
            }
        }

        if ($this->option('model') !== 'all') {
            $model = $this->option('model');
            $entity = new $model();

            if ($entity->definesAsItem) {

                if ($this->option('item') === 'all') {
                    foreach ($entity::all() as $item) {
                        $item->touch();
                    }
                }

                if ($this->option('item') !== 'all') {
                    $entity::findOrFail($this->option('item'))->touch();
                }
            }
        }
    }

    /**
     * @return array
     */
    private function getModels(): array
    {
        $out = [];

        $path = app_path() . "/Models";
        $results = scandir($path);
        foreach ($results as $result) {
            if ($result === '.' or $result === '..') continue;
            $filename = $path . '/' . $result;
            if (is_dir($filename))
            {
                $out = array_merge($out, $this->getModels($filename));
            } else
            {
                $out[] = substr($filename,0,-4);
            }
        }

        foreach ($out as $key => $model) {
            $model = 'App/'.str_replace(app_path().'/', '', $model);
            $model = str_replace('/', '\\', $model);
            $out[$key] = $model;
        }

        return $out;
    }
}
