function makeButtonsOnDragDropElementWork() {
    $('.remove-menu-item').on('mousedown', function (e) {
        console.log(JSON.stringify($('.dd').nestable('serialize')));
        e.stopPropagation();
        return false;
    });
}

function addMenuElement(obj, children = 0) {
    let empty = $(".dd > .dd-empty");

    let model = obj.data('element-class');
    let id = obj.data('element-id');
    let title = obj.data('element-title');

    let menu_id = window.btoa(id + '-' + model + '-' + children);

    if (empty.length) {
        empty.remove();
    }

    if (children === 1) {
        children = ' <span class="badge badge-light-success">+ children</span>';
    } else {
        children = '';
    }

    $(".dd > .dd-list").append('' +
        '<li class="dd-item" data-id="' + menu_id + '">' +
        '<div class="dd-handle">' +
        '<div style="float: left;">' +
        '' + title + '' +
        ' <span class="badge badge-light-primary">' + model + '</span>' +
        children +
        '</div>' +
        '<div class="menu-item-buttons" style="float: right">' +
        ' <span class="buttons">' +
        '<a href="#" class="btn btn-xs btn-icon btn-danger remove-menu-item"><i class="fas fa-trash"></i></a>' +
        '</span>' +
        '</div>' +
        '</div>' +
        '</li>'
    );

    makeButtonsOnDragDropElementWork();

    console.log(JSON.stringify($('.dd').nestable('serialize')));
}

$(document).ready(function () {

    $('.save-menu-button').on("click", function () {

        let resp;

        $.ajax({
            async: false, type: "POST", cache: false, url: $(this).attr("href"),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {"list": JSON.stringify($('.dd').nestable('serialize'))},
            success: function (response) {
                resp = response;
            },
            error: function (response) {

            }
        });

        location.reload();
        return false;
    });

    $('.dd').nestable({
        callback: function (l, e) {
            console.log(JSON.stringify($('.dd').nestable('serialize')));
        },
    });

    makeButtonsOnDragDropElementWork();

    $(document).on("click", '.remove-menu-item', function () {
        $(this).parent().parent().parent().parent().remove();
        let item = $(".dd > .dd-list").find('.dd-item');
        if (!item.length) {
            $('.dd').append('<ol class="dd-empty"><ol>');
        }
        return false;
    });

    $(document).on("click", '.add-many-menu-items', function () {
        $(this).parent().parent().parent().find('table tbody tr').each(function () {
            var checkbox = $(this).find('.table-checkbox');
            var tr = $(this);
            if (checkbox.is(":checked")) {
                tr.find('.add-one-menu-item').trigger('click');
            }
        });

        return false;
    });

    $(document).on("click", '.add-many-menu-items-with-children', function () {
        $(this).parent().parent().parent().find('table tbody tr').each(function () {
            var checkbox = $(this).find('.table-checkbox');
            var tr = $(this);
            if (checkbox.is(":checked")) {
                tr.find('.add-one-menu-item-with-children').trigger('click');
            }
        });

        return false;
    });

    $(document).on("click", '.add-one-menu-item', function () {
        addMenuElement($(this));
        return false;
    });

    $(document).on("click", '.add-one-menu-item-with-children', function () {
        addMenuElement($(this), 1);
        return false;
    });
});
