@extends(theme()->layout())
@section('content')
    <div class="row mt-5">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header card-header-stretch">
                    <h3 class="card-title">{{ __('Select menu items') }}</h3>
                    <div class="card-toolbar">
                        <ul class="nav nav-tabs nav-line-tabs nav-stretch fs-6 border-0">
                            <li class="nav-item">
                                <a class="nav-link active" data-bs-toggle="tab" href="#kt_tab_pane_7">Modules</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#kt_tab_pane_8">Pages</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#kt_tab_pane_9">Post categories</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#kt_tab_pane_11">Custom links</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#kt_tab_pane_12">Product categories</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#kt_tab_pane_13">Brands</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="card-body pt-0">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="kt_tab_pane_7" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['modules']['table']->render() !!}
                        </div>

                        <div class="tab-pane" id="kt_tab_pane_8" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#"
                                       class="badge badge-primary mx-1 add-one-menu-item-with-children"
                                       data-bs-toggle="tooltip"
                                       data-bs-placement="top"
                                       data-element-title="{{ __('root')}}"
                                       data-element-id="0"
                                       data-element-class="{{ get_class(new \ViartasModules\Pages\Models\Accounting\Page()) }}"
                                       title="{{ __('Add root') }}">
                                        + {{ __('root') }}
                                    </a>
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                    <a href="#"
                                       class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items-with-children"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected with children') }}"><i class="fas fa-layer-group"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['pages']['table']->render() !!}
                        </div>

                        <div class="tab-pane fade" id="kt_tab_pane_9" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#"
                                       class="badge badge-primary mx-1 add-one-menu-item-with-children"
                                       data-bs-toggle="tooltip"
                                       data-bs-placement="top"
                                       data-element-title="{{ __('root')}}"
                                       data-element-id="0"
                                       data-element-class="{{ get_class(new \ViartasModules\PostCategories\Models\Accounting\PostCategory()) }}"
                                       title="{{ __('Add root') }}">
                                        + {{ __('root') }}
                                    </a>
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                    <a href="#"
                                       class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items-with-children"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected with children') }}"><i class="fas fa-layer-group"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['post_categories']['table']->render() !!}
                        </div>

                        <div class="tab-pane fade" id="kt_tab_pane_11" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['custom_links']['table']->render() !!}
                        </div>

                        <div class="tab-pane fade" id="kt_tab_pane_12" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['product_categories']['table']->render() !!}
                        </div>

                        <div class="tab-pane fade" id="kt_tab_pane_13" role="tabpanel">
                            <div class="card-header p-0 min-h-20px">
                                <h3 class="card-title"></h3>
                                <div class="card-toolbar">
                                    <a href="#" class="btn btn-xs btn-icon btn-primary mx-1 add-many-menu-items"
                                       data-bs-toggle="tooltip" data-bs-placement="top"
                                       title="{{ __('Add selected') }}"><i class="fas fa-plus-circle"></i></a>
                                </div>
                            </div>
                            {!! $menu_items['brands']['table']->render() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('Drag & Drop') }}</h3>
                    <div class="card-toolbar">
                        <a href="{{ route('accounting.menus.list', ['id' => $element->id]) }}"
                           class="btn btn-success btn-sm save-menu-button">
                            {{ __('Save changes') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <x:core::menus.render :menu="$element" />
                </div>
            </div>
        </div>
    </div>
@endsection
