<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('item_caches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_id')->constrained()->cascadeOnDelete();
            $table->string('locale')->index();
            $table->string('field')->index();
            $table->text('value')->nullable(); //remove non utf8 chars and separators
            $table->timestamps();

            $table->fullText(['value']); // Adding FULLTEXT index
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
