<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->id();
            $table->string('guard')->index();
            $table->string('name')->index();
            $table->jsonb('title')->nullable();
            $table->jsonb('content')->nullable();
            $table->boolean('is_active')->index()->default(1);
            $table->boolean('is_visible')->index()->default(1);
            $table->boolean('is_deleted')->index()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
