<?php

namespace ViartasCore\Auth\Providers;

use Illuminate\Support\ServiceProvider;
use Laravel\Fortify\Fortify;

class FortifyServiceProvider extends ServiceProvider
{
    /**
     * @return void
     */
    public function register(): void
    {
        Fortify::ignoreRoutes();
    }

    /**
     * @return void
     */
    public function boot(): void
    {
        $this->loadRotes();
    }

    /**
     * @return void
     */
    private function loadRotes(): void
    {
        $this->loadRoutesFrom(
            __DIR__ . '/../../routes/routes.php'
        );
    }
}
