<?php

namespace ViartasCore\Auth\Providers;

// use Illuminate\Support\Facades\Gate;
// use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Route;
use ViartasCore\Auth\Drivers\AuthRouteMethodsDriver;
use ViartasCore\Core\Models\User;
use ViartasCore\Core\Providers\BasePackageServiceProvider;

class AuthServiceProvider extends BasePackageServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * @return void
     */
    public function register(): void
    {
        parent::register();

        $this->booting(function () {
            $this->registerPolicies();
        });
    }

    /**
     * @return void
     */
    public function registerPolicies(): void
    {
        foreach ($this->policies() as $model => $policy) {
            Gate::policy($model, $policy);
        }
    }

    /**
     * @return string[]
     */
    public function policies(): array
    {
        return $this->policies;
    }

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     * @throws \ReflectionException
     */
    public function boot(): void
    {
        parent::boot();

        $this->registerPolicies();

        Gate::before(function ($user, $ability) {
            if ($user->hasRole('admin')) {
                return true;
            }
        });

        Gate::define('viewPulse', function (User $user) {
            $access = ['srklt89@gmail.com'];
            return in_array($user->email, $access);
        });

        Route::mixin(new AuthRouteMethodsDriver);
    }
}
