<?php

namespace App\Http\Controllers\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use App\Facades\Asp;
use Illuminate\Http\Request;
use ViartasCore\Core\Facades\Viartas;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  Request  $request
     * @return string|null
     */
    protected function redirectTo(Request $request): ?string
    {
        if (! $request->expectsJson()) {
            return route(Viartas::driver()->app()->login());
        }

        return null;
    }
}
