<?php

namespace ViartasCore\Auth\Facades;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Support\Facades\Facade;
use RuntimeException;
use ViartasCore\Auth\Providers\AuthServiceProvider;

class AuthUi extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return 'authui';
    }

    /**
     * Register the typical authentication routes for an application.
     *
     * @param  array  $options
     * @return void
     *
     * @throws \RuntimeException|BindingResolutionException
     */
    public static function routes(array $options = []): void
    {
        if (! static::$app->providerIsLoaded(AuthServiceProvider::class)) {
            throw new RuntimeException('In order to use the Auth::routes() method, please install the laravel/ui package.');
        }

        static::$app->make('router')->auth($options);
    }
}
