<?php

namespace ViartasCore\Auth\Drivers;

use ViartasCore\Core\Facades\Viartas;

class AuthRouteMethodsDriver
{
    /**
     * Register the typical authentication routes for an application.
     *
     * @return callable
     */
    public function auth(): callable
    {
        return function ($options = []) {
            $namespace = class_exists($this->prependGroupNamespace('\ViartasCore\Auth\Controllers\LoginController')) ? null : 'App\Http\Controllers';

            $this->group(['namespace' => $namespace], function() use($options) {

                // Login Routes...
                if ($options['login'] ?? true) {
                    $this->get('login', '\ViartasCore\Auth\Controllers\LoginController@showLoginForm')->name('login.index');
                    $this->post('login', '\ViartasCore\Auth\Controllers\LoginController@login');
                }

                // Logout Routes...
                if ($options['logout'] ?? true) {
                    $this->post('logout', '\ViartasCore\Auth\Controllers\LoginController@logout')->name('logout.index');
                }

                // Registration Routes...
                if ($options['register'] ?? true) {
                    $this->get('register', '\ViartasCore\Auth\Controllers\RegisterController@showRegistrationForm')->name('register.index');
                    $this->post('register', '\ViartasCore\Auth\Controllers\RegisterController@register');
                }

                // Password Reset Routes...
                if ($options['reset'] ?? true) {
                    $this->resetPassword();
                }

                // Password Confirmation Routes...
                if ($options['confirm'] ??
                    class_exists($this->prependGroupNamespace('\ViartasCore\Auth\Controllers\ConfirmPasswordController'))) {
                    $this->confirmPassword();
                }

                // Email Verification Routes...
                if ($options['verify'] ?? false) {
                    $this->emailVerification();
                }
            });
        };
    }

    /**
     * Register the typical reset password routes for an application.
     *
     * @return callable
     */
    public function resetPassword(): callable|\Closure
    {
        return function () {
            $this->get('password/reset', '\ViartasCore\Auth\Controllers\ForgotPasswordController@showLinkRequestForm')->name('password.request');
            $this->post('password/email', '\ViartasCore\Auth\Controllers\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
            $this->get('password/reset/{token}', '\ViartasCore\Auth\Controllers\ResetPasswordController@showResetForm')->name('password.reset');
            $this->post('password/reset', '\ViartasCore\Auth\Controllers\ResetPasswordController@reset')->name('password.update');
        };
    }

    /**
     * Register the typical confirm password routes for an application.
     *
     * @return callable|\Closure
     */
    public function confirmPassword(): callable|\Closure
    {
        return function () {
            $this->get('password/confirm', '\ViartasCore\Auth\Controllers\ConfirmPasswordController@showConfirmForm')->name('password.confirm');
            $this->post('password/confirm', '\ViartasCore\Auth\Controllers\ConfirmPasswordController@confirm');
        };
    }

    /**
     * Register the typical email verification routes for an application.
     *
     * @return callable
     */
    public function emailVerification(): callable|\Closure
    {
        return function () {
            $this->get('email/verify', '\ViartasCore\Auth\Controllers\VerificationController@show')->name('verification.notice');
            $this->get('email/verify/{id}/{hash}', '\ViartasCore\Auth\Controllers\VerificationController@verify')->name('verification.verify');
            $this->post('email/resend', '\ViartasCore\Auth\Controllers\VerificationController@resend')->name('verification.resend');
        };
    }
}
