<?php

namespace ViartasCore\Auth\Controllers;

use App\Http\Controllers\AppController;
use App\Http\Controllers\Controller;
use App\Facades\Asp;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Foundation\Auth\RedirectsUsers;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Laravel\Fortify\Contracts\LoginResponse;
use ViartasCore\Core\Facades\Viartas;

class LoginController extends Controller //implements LoginResponse
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;
    //use RedirectsUsers;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['theme', function ($request, \Closure $next) {

            $route = $request->route();
            $routeControllerParts = explode('@', $route->getAction()['controller']);

            $routeController = ltrim($routeControllerParts[0], '\\');
            $routeMethod = $routeControllerParts[1];

            $themeControllers = Viartas::driver()->theme()->controllers();

            if (isset($themeControllers[$routeController])) {

                $themeController = $themeControllers[$routeController] . '@' . $routeMethod;

                $routeAction = array_merge($route->getAction(), [
                    'uses'       => $themeController,
                    'controller' => $themeController,
                ]);

                $route->setAction($routeAction);
                $route->controller = false;
            }

            return $next($request);
        }]);

        $this->middleware('guest')->except(['logout', 'accounting.logout']);
    }

    public function showLoginForm()
    {
        if (!session()->has('url.intended'))
        {
            session(['url.intended' => url()->previous()]);
        }

        return theme_view(Viartas::driver()->app()->current()->tag.'.auth.login');
    }

    public function redirectTo () {
        $redirect = (session()->get('url.intended') ? session()->get('url.intended') : Viartas::driver()->app()->path());
        return Viartas::driver()->app()->path() === 'web' ? '/home' : $redirect;
    }

    public function redirectPath()
    {
        if (method_exists($this, 'redirectTo')) {
            return $this->redirectTo();
        }

        return property_exists($this, 'redirectTo') ? $this->redirectTo : '/homes';
    }

    /*public function toResponse()
    {
        var_dump(Asp::getAppRoute());exit;
        if  (str_contains(redirect()->intended($this->redirectPath())->getTargetUrl(), 'logout'))
            return redirect(Asp::getAppRoute());

        return redirect()->intended($this->redirectPath());
    }*/

    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        if ($response = $this->authenticated($request, $this->guard()->user())) {
            return $response;
        }

        $path = $this->redirectPath();

        if (str_contains(redirect()->intended($path)->getTargetUrl(), 'logout'))
            $redirectPath = Viartas::driver()->app()->route();
        else
            $redirectPath = $path;

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect()->intended($redirectPath);
    }

    /*public function login(Request $request)
    {
    }*/

    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->flush();

        $request->session()->regenerate();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect()->guest(route(Viartas::driver()->app()->login()));
    }

}
