@if($element->id)
    <!--begin::Navbar-->
    <div class="card mb-5 mt-10 mb-xxl-8">
        <div class="card-body pt-9 pb-0">
            <!--begin::Details-->
            <div class="d-flex flex-wrap flex-sm-nowrap">
                @if($element->getFirstMedia())
                    <x:content::top.media :element="$element" />
                @endif
                <!--begin::Info-->
                <div class="flex-grow-1">
                    <!--begin::Title-->
                    <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                        <!--begin::User-->
                        <div class="d-flex flex-column">
                            <!--begin::Name-->
                            <div class="d-flex align-items-center mb-2">
                                <a href="#" class="text-gray-900 text-hover-primary fs-2 fw-bold me-1">{{ __('Edit '.$element->elementTitle()) }}: {{ $element->title ?? $element->name ?? '' }}</a>
                                <a href="#">
                                    <i class="ki-duotone ki-verify fs-1 text-primary">
                                        <span class="path1"></span>
                                        <span class="path2"></span>
                                    </i>
                                </a>
                            </div>
                            <!--end::Name-->
                            @if($element->usesRecursiveRelations() && $element->ancestors->count())
                                <!--begin::Info-->
                                <div class="d-flex flex-wrap fw-semibold fs-6 mb-4 pe-2">
                                    @foreach($element->ancestors as $ancestor)
                                        <a href="{{ $ancestor->routeEdit()->getRoutePath() }}" target="_blank" class="d-flex align-items-center text-gray-500 text-hover-primary me-1 mb-2">
                                            <span class="badge badge-light-primary">
                                                <i class="fas fa-folder-open text-primary"></i> &nbsp;{{ $ancestor->title }}
                                            </span>
                                        </a>
                                        @if($ancestor->ancestors->count())
                                            <span class="d-flex align-items-center text-gray-500 text-hover-primary me-1 mb-2">
                                                <i class="fas fa-arrow-alt-circle-left"></i>
                                            </span>
                                        @endif
                                    @endforeach
                                </div>
                                <!--end::Info-->
                            @endif
                        </div>
                        <!--end::User-->
                        <!--begin::Actions-->
                        <div class="d-flex my-4">
                            <x-content-buttons :buttons="$element->buttons()" type="summaries" />
                        </div>
                        <!--end::Actions-->
                    </div>
                    <!--end::Title-->
                    <x:content::top.widgets :element="$element" />
                </div>
                <!--end::Info-->
            </div>
            <!--end::Details-->
            <x:content::top.menu :element="$element" />
        </div>
    </div>
    <!--end::Navbar-->
@else
    <x:content::top.create :element="$element" title="{{ __('Create new '.$element->elementTitle()) }}" />
@endif
