<?php

namespace ViartasBuilders\Tables\Traits;

use Cache;
use ViartasBuilders\Tables\DataTables;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

trait HasTable
{
    /**
     * @param DataTables $table
     * @param Request $request
     * @param Application|Factory|View $view
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function tableBuilder(DataTables $table, Request $request, Application|Factory|View $view): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        if ($request->draw) {
            return $this->table($table);
            /*return Cache::remember('datatables-draw-'.$table->id(), 60, function () use ($table, $request) {
                return $this->table($table);
            });*/
        }

        if ($request->filter) {
            return Cache::remember('datatables-filters-'.$table->id().'-'.$request->filter, 60, function () use ($table, $request) {
                return $this->filters($table, $request);
            });
        }

        return $view;
    }

    /**
     * @param DataTables $table
     * @return array
     */
    public function table(DataTables $table): array
    {
        return $table->build()->fetchData();
    }

    /**
     * @param DataTables $table
     * @param Request $request
     * @return string
     */
    public function filters(DataTables $table, Request $request): string
    {
        return $table->getFilters();
    }
}
