<?php

namespace ViartasBuilders\Tables\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class TablesBuilderServiceProvider extends ServiceProvider
{
    /**
     * @var string
     */
    protected string $viewLocation = 'Bootstrap5';

    /**
     * @return void
     */
    public function register()
    {

    }

    /**
     * @return void
     */
    public function boot(): void
    {
        $this->collectComponents(__DIR__ . '/../Components');
    }

    /**
     * @return void
     */
    public function loadAnonymousComponents(): void
    {
        Blade::anonymousComponentPath(
            __DIR__ . '/Components/view',
            'form'
        );
    }

    /**
     * @param $componentsFolder
     * @return void
     */
    protected function collectComponents($componentsFolder): void
    {
        $components = [];

        View::addLocation(__DIR__ . '/../Components/' .$this->viewLocation);
        $componentsViews = File::allFiles($componentsFolder.'/'.$this->viewLocation);

        foreach ($componentsViews as $component) {

            $alias = substr($component->getRelativePathname(),0, -10);
            $name = $alias;
            //$name = preg_replace('/^(table-)/', '', $alias);

            $name = explode("-", $name);

            foreach ($name as $key => $value) {
                $name[$key] = ucfirst($value);
            }

            $name = implode('', $name);
            $components[$alias] = 'ViartasBuilders\\Tables\\Components\\'.$name.'Component';
        }

        Blade::components($components);
    }
}
