<?php

namespace ViartasBuilders\Tables;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class DataTablesRow
{
    protected string $defaultKey = 'id';
    protected string $defaultTitle = 'example';

    private string $name;
    private string $field;

    private array $replaces = [];

    private bool $orderable = true;
    private bool $visible = true;
    private bool $selectable = false;
    private bool $range = false;
    private bool $searchable = false;
    private bool $getable = true;
    private bool $checkbox = false;
    private string $defaultFilterType;

    public mixed $dt_render;

    public mixed $dt_filter = false;

    private array $buttons = [];

    public function __construct()
    {
        return $this->setConfig('field', $this->defaultKey)
            ->filters()
            //->filter()
            ->order()
            ->render();
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     */
    public function __call($name, $arguments): mixed
    {
        return call_user_func_array($this->{$name}, $arguments);
    }

    private function setConfig (string $key, string|callable|array $value): self
    {
        $this->$key = $value;
        return $this;
    }

    public function get ($key): string
    {
        return $this->$key;
    }

    public function field (string|null $fieldName = null): self
    {
        return $this->setConfig('field', $fieldName ?? $this->defaultKey);
    }

    public function title (string|null $fieldTitle = null): self
    {
        return $this->setConfig('title', $fieldTitle ?? $this->defaultTitle);
    }

    public function setOrderable (bool $boolean = true): self
    {
        return $this->setConfig('orderable', $boolean);
    }

    public function orderable(): bool
    {
        return $this->orderable;
    }

    public function setVisible (bool $boolean = true): self
    {
        return $this->setConfig('visible', $boolean);
    }

    public function visible(): bool
    {
        return $this->visible;
    }

    public function setGetable (bool $boolean = true): self
    {
        return $this->setConfig('getable', $boolean);
    }

    public function getable(): bool
    {
        return $this->getable;
    }

    public function setRange (bool $boolean = true): self
    {
        return $this->setConfig('range', $boolean);
    }

    public function range(): bool
    {
        return $this->range;
    }

    public function setSelectable (bool $boolean = true): self
    {
        return $this->setConfig('selectable', $boolean);
    }

    public function selectable(): bool
    {
        return $this->selectable;
    }

    public function setSearchable (bool $boolean = true): self
    {
        return $this->setConfig('searchable', $boolean);
    }

    public function searchable(): bool
    {
        return $this->searchable;
    }

    public function setCheckbox (bool $boolean = true): self
    {
        return $this->setConfig('checkbox', $boolean);
    }

    public function checkbox(): bool
    {
        return $this->checkbox;
    }

    public function order (callable $function = null): self
    {
        return $this->setConfig('dt_order', $function ?? function (Builder $builder, string $direction) {
            return $builder->orderBy($this->get('field'), $direction);
        });
    }

    public function render (callable $function = null): self
    {
        return $this->setConfig('dt_render', $function ?? function (Model $model) {
            return $model->{$this->field};
        });
    }

    public function filters (callable $function = null): self
    {
        return $this->setConfig('dt_filters', $function ?? function (Model $model) {
            $response = [];

            $data = $model->select($this->field)->groupBy($this->field)->get();

            foreach ($data as $datum) {
                $response[] = [
                    'label' => $datum->{$this->field},
                    'value' => $datum->{$this->field},
                    'values' => [],
                ];
            }

            return $response;
        });
    }

    public function filter (callable $function = null): self
    {
        return $this->setConfig('dt_filter', $function ?? function (Builder $builder, array $searches) {
            foreach ($searches as $key => $value) {
                $builder->where($value, 'like', '%' . $key . '%');
            }

            return $builder;
        });
    }

    public function replaces (array $array = []): self
    {
        return $this->setConfig('replaces', $array);
    }

    public function search (callable|string|null $function = null): self
    {
        return $this->setConfig('dt_search', $function ?? function (null|Builder $builder = null) { return $this->field ?? $this->defaultKey; });
    }

    /**
     * @param DataTablesButton $button
     * @return $this
     */
    public function add(DataTablesButton $button): self
    {
        $this->buttons[$button->title()] = $button;
        return $this;
    }

    /**
     * @param DataTablesButton $button
     * @return $this
     */
    public function removeButton(DataTablesButton $button): self
    {
        if (isset($this->buttons[$button->title()])) {
            unset($this->buttons[$button->title()]);
        }
        return $this;
    }

    /**
     * @return array
     */
    public function buttons(): array
    {
        return $this->buttons;
    }

    public function button(string $title): DataTablesButton
    {
        return $this->buttons[$title];
    }
}
