<?php

namespace ViartasBuilders\Tables;

use ViartasCore\Core\Drivers\Route;
use Illuminate\Database\Eloquent\Model;
use ViartasCore\Core\Drivers\RouteDriver;

class DataTablesButton
{
    private string $title = 'example_button';
    private string $elementTitle;
    private RouteDriver $route;
    private string $method = "GET";
    private string $class = '';
    private string $id = '';
    private string $icon = 'fa-edit';
    private string $size = 'xs';
    private string $color = 'primary';

    private Model $model;

    private bool $withConfirmation = false;

    public function __construct()
    {
        $this->setRoute();
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     */
    public function __call($name, $arguments): mixed
    {
        return call_user_func_array($this->{$name}, $arguments);
    }

    /**
     * @param string $key
     * @param mixed $value
     * @return self
     */
    private function setConfig (string $key, mixed $value): self
    {
        $this->$key = $value;
        return $this;
    }

    /**
     * @param $key
     * @return string
     */
    public function get ($key): string
    {
        return $this->$key;
    }

    /**
     * @param string $title
     * @return self
     */
    public function setTitle (string $title): self
    {
        return $this->setConfig('title', $title);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    /**
     * @param string $elementTitle
     * @return self
     */
    public function setElementTitle (string $elementTitle): self
    {
        return $this->setConfig('elementTitle', $elementTitle);
    }

    /**
     * @return string|null
     */
    public function elementTitle(): string|null
    {
        return $this->elementTitle ?? null;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setClass (string $class): self
    {
        return $this->setConfig('class', $class);
    }

    /**
     * @return string
     */
    public function class(): string
    {
        return $this->class;
    }

    /**
     * @param string $id
     * @return self
     */
    public function setId (string $id): self
    {
        return $this->setConfig('id', $id);
    }

    /**
     * @return string
     */
    public function id(): string
    {
        return $this->id;
    }

    /**
     * @param string $icon
     * @return self
     */
    public function setIcon (string $icon): self
    {
        return $this->setConfig('icon', $icon);
    }

    /**
     * @return string
     */
    public function icon(): string
    {
        return $this->icon;
    }

    /**
     * @param string $size
     * @return self
     */
    public function setSize (string $size): self
    {
        return $this->setConfig('size', $size);
    }

    /**
     * @return string
     */
    public function size(): string
    {
        return $this->size;
    }

    /**
     * @param string $color
     * @return self
     */
    public function setColor (string $color): self
    {
        return $this->setConfig('color', $color);
    }

    /**
     * @return string
     */
    public function color(): string
    {
        return $this->color;
    }

    public function setConfirm (bool $confirm = true): self
    {
        return $this->setConfig('withConfirmation', $confirm);
    }

    public function confirm(): bool
    {
        return $this->withConfirmation;
    }

    /**
     * @param Model $model
     * @return self
     */
    public function setModel (Model $model): self
    {
        return $this->setConfig('model', $model);
    }

    /**
     * @return Model
     */
    public function model(): Model
    {
        return $this->model;
    }

    /**
     * @param callable|null $function
     * @return self
     */
    public function setRoute (callable $function = null): self
    {
        return $this->setConfig('dt_route', $function ?? function (Model $model) {
            return new RouteDriver();
        });
    }

    /**
     * @param RouteDriver $route
     * @return self
     */
    public function bindRoute(RouteDriver $route): self
    {
        return $this->setConfig('route', $route);
    }

    /**
     * @return self
     */
    public function postRoute(): self
    {
        return $this->setConfig('method', 'POST');
    }

    /**
     * @return self
     */
    public function getRoute(): self
    {
        return $this->setConfig('method', 'GET');
    }

    /**
     * @return string
     */
    public function method(): string
    {
        return $this->method;
    }

    /**
     * @return RouteDriver
     */
    public function route(): RouteDriver
    {
        return $this->route;
    }

    /**
     * @return self
     */
    public function destroyButton(): self
    {
        return $this->setColor('danger')
            ->setTitle(__('Destroy'))
            ->setIcon('fa-trash')
            ->setConfirm()
            ->postRoute()
            ->setRoute(function (Model $model) {
                return $model->routeDestroy();
            });
    }

    /**
     * @return self
     */
    public function editButton(): self
    {
        return $this->setRoute(function (Model $model) {
            return $model->routeEdit();
        })->getRoute()->setTitle(__('Edit'));
    }
}
