<div class="table-responsive">
    <table id="{{ $table->id() }}" class="dataTable table table-striped table-hover table-row-bordered gy-1 gs-1 border rounded has-checkboxes {{ $table->class() }}">
        <thead>
        <tr>
            @foreach($table->getRows() as $row)
                <th>{{ $row->get('title') }}</th>
            @endforeach
        </tr>
        </thead>
        <tbody>

        </tbody>
    </table>
</div>
@section('section-js')
    <script type="module">
        $("document").ready(function () {
            $(document).on("click", ".table-actions .dropdown-item", function () {
                const route = $(this).attr("data-route");
                const value = $(this).attr("data-value");
                const label = $(this).attr("data-label");

                $.ajax({
                    async: false, type: "PATCH", cache: false, url: route,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {"value": value},
                });

                $(this).parent().parent().parent().find(".dropdown-toggle").html(label);

                return false;
            });

            $(document).on("change", ".form-switch .form-check-input", function () {
                let enabled = "0";
                const route = $(this).attr("data-route");

                if ($(this).is(":checked")) {
                    enabled = "1";
                }

                $.ajax({
                    async: false, type: "PATCH", cache: false, url: route,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {"value": enabled},
                });
            });
        });
    </script>
@endsection
@push('push-js')
<script type="module">
    $("document").ready(function () {
        var dTableUpdate = $('#{{ $table->id() }}').dataTable({
            processing: true,
            serverSide: true,
            ajax: {
                type: 'GET',
                url: '{{ $table->route() }}',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
            },
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_',
            },
            'columnDefs': [
                { orderable: false, targets: [3] }
            ],
            order: [[0, 'desc']],
            lengthMenu: [
                [50, 100, 500, -1],
                [50, 100, 500, 'All'],
            ],
            initComplete : function() {
                let selectedValues = [];

                $("#{{ $table->id() }} thead .text_filter").each(function () {
                    selectedValues[parseInt($(this).attr('rel'))] = $(this).val();
                });

                $("#{{ $table->id() }} thead select").each(function () {
                    var resp;
                    $.ajax({
                        async: false, type: "GET", cache: false, url: "{{ $table->filters() }}?filter=" + $(this).attr("rel"),
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {"dataArray": JSON.stringify(selectedValues)},
                        success: function (response) {
                            resp = response;
                        }
                    });
                    $(this).html('').append(resp);
                    $(this).select2({"placeholder": "-", allowClear: true});

                    $(".daterangepicker-input").daterangepicker({
                        timePicker: false,
                        singleDatePicker: true,
                        showDropdowns: true,
                        "autoApply": true,
                        locale: {
                            format: "YYYY-MM-DD"
                        }
                    }).val('').trigger('change');
                });
            },
            "dom":
                "<'row'" +
                "<'col-sm-6 d-flex align-items-center justify-conten-start'l>" +
                "<'col-sm-6 d-flex align-items-center justify-content-end'f>" +
                ">" +

                "<'table-responsive'tr>" +

                "<'row'" +
                "<'col-sm-12 col-md-5 d-flex align-items-center justify-content-center justify-content-md-start'i>" +
                "<'col-sm-12 col-md-7 d-flex align-items-center justify-content-center justify-content-md-end'p>" +
                ">"
        });

        new $.fn.dataTable.ColumnFilter(dTableUpdate, {
            @foreach($table->getRows() as $key => $row)
                @if($row->searchable())
                    {{ $key }}: {
                        type: 'text',
                        attr: {
                            placeholder: '',
                            "class": "form-control input-sm",
                        }
                    },
               @endif
               @if($row->checkbox())
                   {{ $key }}: {
                   type: 'checkbox',
                       attr: {
                           "class": "daterangepicker",
                       }
                   },
               @endif
               @if($row->range())
                   {{ $key }}: {
                       type: 'dateRange',
                       attr: {
                           "class": "daterangepicker",
                       }
                   },
               @endif
               @if($row->selectable())
                    {{ $key }}: {
                        type: 'select',
                        values: [{value: 'value',  label: 'Label'}],
                        attr: {
                            rel: '{{ $row->get('field') }}',
                            "data-placeholder": "-",
                            "class": "form-select form-select-sm select3",
                        }
                    },
               @endif
            @endforeach
        });
    });
</script>
@endpush
