@if($button->method() == 'GET')
    <a href="{{ $button->route()->getRoutePath() }}"
       class="
        btn
        btn-{{ $button->color() }}
        btn-{{ $button->size() }}
        {{ $button->class() }}
        @if($button->icon() != '') btn-icon @endif
        @if($button->confirm()) confirm-button @endif
        "
       title="{{ $button->title() }}"
       rel="{{ $button->model()->id }}"
       @if($button->id()) id="{{ $button->id() }}" @endif
       data-element-title="{{ $button->model()->{$button->elementTitle() ?? 'title'} }}"
       data-element-id="{{ $button->model()->id }}"
       data-element-class="{{ get_class($button->model()) }}"
    >
        @if($button->icon() != '')
            <i class="fas {{ $button->icon() }}"></i>
        @else
            {{ $button->title() }}
        @endif
    </a>
@else
    <form action="{{ $button->route()->getRoutePath() }}" method="{{ $button->method() }}" class="d-inline-block">
        @csrf
        <button type="submit" class="
        btn
        btn-{{ $button->color() }}
        btn-{{ $button->size() }}
        {{ $button->class() }}
        @if($button->icon() != '') btn-icon @endif
        @if($button->confirm()) confirm-form @endif
        "
            title="{{ $button->title() }}"
            rel="{{ $button->model()->id }}"
            @if($button->id()) id="{{ $button->id() }}" @endif
                data-element-title="{{ $button->model()->{$button->elementTitle() ?? 'title' } }}"
                data-element-id="{{ $button->model()->id }}"
                data-element-class="{{ get_class($button->model()) }}"
        >
            @if($button->icon() != '')
                <i class="fas {{ $button->icon() }}"></i>
            @else
                {{ $button->title() }}
            @endif

        </button>
    </form>
@endif
