<?php

namespace ViartasBuilders\Menus;

use Illuminate\Support\Collection;
use ViartasCore\Core\Models\Menu as MenuModel;

class Menu
{
    /**
     * @var MenuModel
     */
    private MenuModel $menu;

    /**
     * @param MenuModel $menu
     */
    public function __construct(MenuModel $menu)
    {
        $this->menu = $menu;
    }

    /**
     * @return MenuModel
     */
    public function data(): MenuModel
    {
        return $this->menu;
    }

    /**
     * @return Collection
     */
    public function list(): Collection
    {
        $items = [];
        foreach ($this->menu->items as $item) {
            if ($item->element === 0) {
                $items = array_merge($items, $this->extractModelItems($item));
                continue;
            }

            $items[] = new MenuItem($item);
        }

        foreach ($items as $key => $item) {
            if ($item->route() && !$item->route()->isAvailable()) {
                unset($items[$key]);
            }
        }

        return collect($items);
    }

    /**
     * @param \ViartasCore\Core\Models\MenuItem $item
     * @return array
     */
    private function extractModelItems(\ViartasCore\Core\Models\MenuItem $item): array
    {
        $items = [];
        $model = (new $item->class);

        if ($model->hasField($model->getParentKeyName())) {
            $rootItems = $model->whereNull($model->getParentKeyName())->orderBy('title')->get();

            foreach ($rootItems as $item) {
                $items[] = new MenuItem($item);
            }
        }

        return $items;
    }

    /**
     * @return string
     */
    public function layout(): string
    {
        return $this->menu->layout;
    }
}
