<?php

namespace ViartasBuilders\Forms\Traits;

use ViartasBuilders\Forms\Fields\TextareaField;
use ViartasBuilders\Forms\Fields\TextField;

Trait HasTranslations {

    protected bool $translatable = false;
    protected string $translatableName = '';
    private bool $convertedToTranslatable = false;

    /**
     * @param bool $translatable
     * @return TextareaField|TextField|HasTranslations
     */
    public function setTranslatable(bool $translatable): self
    {
        return $this->setAttribute('translatable', $translatable);
    }

    /**
     * @return bool
     */
    public function translatable(): bool
    {
        return $this->translatable;
    }

    /**
     * @param string $name
     * @return HasTranslations|TextareaField|TextField
     */
    public function setName(string $name): self
    {
        if ($this->translatable && !$this->convertedToTranslatable) {
            $this->convertedToTranslatable = true;

            $filed_rules = $this->rules();

            $rules = ['array', 'min:1'];

            $this->setRules($rules);

            $this->setCustomRules([
                $name.'.*' => array_merge($filed_rules, [
                    'sometimes',
                ])
            ]);

            $this->component = str_replace(
                ' :field="',
                '-translatable :field="',
                $this->component
            );
        }

        if (!preg_match('/\[\]/', $name) && $this->translatable) {
            $name .= '[]';
        }

        return $this->setAttribute('name', $name);
    }
}
