<?php

namespace ViartasBuilders\Forms\Groups;

use ViartasBuilders\Forms\Contracts\GroupContract;
use ViartasBuilders\Forms\Group;

class PlainGroup extends Group implements GroupContract
{
    const COMPONENT = 'x-form-group-plain';

    public function attributes (): array
    {
        return [
            'name' => $this->name(),
            'title' => $this->title(),
            'size' => $this->size(),
        ];
    }

    public function render(string|null $component = null, array|null $attributes = []): string
    {
        return parent::render(self::COMPONENT, $this->attributes());
    }
}
