<?php

namespace ViartasBuilders\Forms;

use ViartasBuilders\Forms\Groups\CardGroup;
use ViartasBuilders\Forms\Groups\ModalGroup;
use ViartasBuilders\Forms\Groups\PlainGroup;
use ViartasBuilders\Forms\Groups\SimpleGroup;
use Illuminate\Support\Facades\Blade;
class Group
{
    const SIMPLE = SimpleGroup::class;
    const CARD = CardGroup::class;
    const MODAL = ModalGroup::class;
    const PLAIN = PlainGroup::class;

    const COMPONENT = 'x-form-group-simple';

    private string $name = 'example_name';
    private string $title = 'example_title';
    private string $layout = self::SIMPLE;

    private string|bool $grid = false;

    private string $id = "";
    private string $class = "";
    private int $size = 12;
    private string $content_top = "";
    private string $content_bottom = "";

    private bool $translatable = false;

    /**
     * @param array $config
     */
    public function __construct(array $config = [])
    {
        $this->setConfigFromArray($config);
    }

    /**
     * @param array $config
     * @return self
     */
    private function setConfigFromArray(array $config): self
    {
        foreach ($config as $key => $value) {
            $this->{$key} = $value;
        }

        return $this;
    }

    /**
     * @param string $key
     * @param string $value
     * @return self
     */
    private function setAttribute(string $key, string $value): self
    {
        $this->{$key} = $value;
        return $this;
    }

    /**
     * @param bool $translatable
     * @return self
     */
    public function setTranslatable(bool $translatable): self
    {
        return $this->setAttribute('translatable', $translatable);
    }

    /**
     * @return bool
     */
    public function translatable(): bool
    {
        return $this->translatable;
    }

    /**
     * @param string $title
     * @return self
     */
    public function setTitle(string $title): self
    {
        return $this->setAttribute('title', $title);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name): self
    {
        return $this->setAttribute('name', $name);
    }

    /**
     * @return string
     */
    public function name(): string
    {
        return $this->name;
    }

    /**
     * @return string|bool
     */
    public function grid(): string|bool
    {
        return $this->grid;
    }

    /**
     * @param string $id
     * @return self
     */
    public function setId(string $id): self
    {
        return $this->setAttribute('id', $id);
    }

    /**
     * @return string
     */
    public function id(): string
    {
        return $this->id;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setClass(string $class): self
    {
        return $this->setAttribute('class', $class);
    }

    /**
     * @return string
     */
    public function class(): string
    {
        return $this->class;
    }

    /**
     * @param int $size
     * @return self
     */
    public function setSize(int $size): self
    {
        return $this->setAttribute('size', $size);
    }

    /**
     * @return int
     */
    public function size(): int
    {
        return $this->size;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setContentTop(string $content): self
    {
        return $this->setAttribute('content_top', $content);
    }

    /**
     * @return string
     */
    public function contentTop(): string
    {
        return $this->content_top;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setContentBottom(string $content): self
    {
        return $this->setAttribute('content_bottom', $content);
    }

    /**
     * @return string
     */
    public function contentBottom(): string
    {
        return $this->content_bottom;
    }

    /**
     * @param string|null $component
     * @param array|null $attributes
     * @return string
     */
    public function render (string|null $component, array|null $attributes = []): string
    {
        $content = '';
        foreach ($attributes as $key => $value) {
            $content .= ' :'.$key.'="$'.$key.'"';
        }

        return Blade::render(
            '<'.($component ?? self::COMPONENT).$content.'>%s</'.($component ?? self::COMPONENT).'>', $attributes
        );
    }
}
