<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Traits\HasTranslations;
use Illuminate\Support\Facades\Blade;

class TextareaField extends Field implements FieldContract
{
    use HasTranslations;

    protected string $component = '<x-form-element-textarea :field="$field" />';
    public function __construct(array $config = [])
    {
        $this->setClass('h-150px');
        $this->setRules([
            'string',
        ]);

        parent::__construct($config);
    }

    public function render(): string
    {
        return Blade::render($this->component, ['field' => $this]);
    }
}
